#!/bin/bash

echo "Creating user liferay."
useradd liferay --user-group --password liferay1

# Setup my environment
. /vagrant/liferay/portal.dev.profile

# Setup the profile for the liferay user
cp /vagrant/liferay/portal.dev.profile /home/liferay/.bash_profile
sed -i.bak "s,JDK_INSTALL_LOCATION,${JDK_INSTALL_LOCATION},g" /home/liferay/.bash_profile
sed -i.bak "s,VAGRANT_LIFERAY_SP,${VAGRANT_LIFERAY_SP},g" /home/liferay/.bash_profile
sed -i.bak "s,VAGRANT_LIFERAY_BUILD_ID,${VAGRANT_LIFERAY_BUILD_ID},g" /home/liferay/.bash_profile
sed -i.bak "s,VAGRANT_LIFERAY_BASE_VERSION,${VAGRANT_LIFERAY_BASE_VERSION},g" /home/liferay/.bash_profile
sed -i.bak "s,VAGRANT_TOMCAT_VERSION,${VAGRANT_TOMCAT_VERSION},g" /home/liferay/.bash_profile
chown liferay:liferay /home/liferay/.bash_profile

if [ ! -d "/u01/app" ]; then
  mkdir -p /u01/app
fi

if [ ! -d "/usr/java" ]; then
  mkdir -p /usr/java
fi

if [ ! -d ${JAVA_HOME} ]; then

	if [ ! -f ${SOFTWARE_DIRECTORY}/${JDK_FILENAME} ]; then
		# Download the file from the tools server.
		echo "Downloading file ${BASE_TOOLS_URL}/java/${JDK_FILENAME}."
		wget -q --tries=20 --continue --retry-connrefused --waitretry=5 --read-timeout=20 ${BASE_TOOLS_URL}/java/${JDK_FILENAME} -O ${SOFTWARE_DIRECTORY}/${JDK_FILENAME}
		
		if [ $? -ne 0 ]; then
			echo "Error Downloading File: ${JDK_FILENAME} from location ${BASE_TOOLS_URL}/java. Check network connectivity and file existence and then retry."
			exit $?
		fi
	fi

	echo "Extracting JDK..."
	tar zxvf ${SOFTWARE_DIRECTORY}/${JDK_FILENAME} -C /usr/java
fi

chown -R liferay:liferay /u01/*

# disable iptables on boot so that we can get to our servers
chkconfig iptables off
/etc/init.d/iptables save
/etc/init.d/iptables stop

## RHEL/CentOS 6 64-Bit ##
wget http://download.fedoraproject.org/pub/epel/6/x86_64/epel-release-6-8.noarch.rpm
rpm -ivh epel-release-6-8.noarch.rpm

yum install -y htop

	